/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmDataFormatter;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmDataValidator;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Node;
import com.ibm.hwmca.fw.servlet.pmod.util.NoStandardFormatterException;
import com.ibm.hwmca.fw.servlet.pmod.util.ObjectFormatter;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ps.wcl.components.message.IMessageConsumer;
import com.ibm.ps.wcl.components.message.IMessageProducer;
import com.ibm.ps.wcl.components.message.MessageInfo;
import com.ibm.ps.wcl.core.TriggerContext;
import com.ibm.ps.wcl.core.WComponent;
import com.ibm.ps.wcl.core.form.IValidator;
import com.ibm.ps.wcl.core.form.WTimeChooser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class WclGlueValidator
implements IValidator,
IMessageProducer {
    private static final String TRACE_MASKF = "XPMWGLVF";
    private List validators = new ArrayList();
    private PmDataFormatter formatter = null;
    private Class propertyType = null;
    private String objectScopeId = null;
    private Node node = null;
    private PanelModel panelModel = null;
    private Set consumerList = new HashSet();
    private String lastErrorMessageId = null;

    public WclGlueValidator(PanelModel panelModel) {
        this.panelModel = panelModel;
    }

    public WclGlueValidator(Node node, String objectScopeId) {
        this.objectScopeId = objectScopeId;
        this.node = node;
    }

    private PanelModel getPanelModel() {
        if (this.panelModel == null && this.node != null) {
            this.panelModel = this.node.getPanelModel();
        }
        return this.panelModel;
    }

    public String getObjectScopeId() {
        return this.objectScopeId;
    }

    public void setFormatter(PmDataFormatter formatter) {
        this.formatter = formatter;
    }

    public List getValidators() {
        return this.validators;
    }

    public void addValidator(PmDataValidator pmDataValidator) {
        this.validators.add(pmDataValidator);
    }

    public PmDataFormatter getFormatter() {
        return this.formatter;
    }

    public void setPropertyType(Class propertyType) {
        this.propertyType = propertyType;
    }

    public boolean validate(TriggerContext tc, WComponent comp, Object newValue) {
        Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() entry (" + this + ")");
        Trace.trace(TRACE_MASKF, "comp= " + comp);
        PanelModel pm = this.panelModel == null ? this.node.getDocumentRoot().getPanelModel().getImplAccess().getOuterMostPanelModel() : this.panelModel;
        WComponent causeComponent = pm.getImplAccess().getPanelModelTaskPortal().getContentManager().getWclFacade().getTriggerManager().getTargetComponent(tc);
        Trace.trace(TRACE_MASKF, "[mjh]causing component is: " + causeComponent);
        if (!pm.getImplAccess().isAWclCancelComponent(causeComponent)) {
            try {
                if (!this.validators.isEmpty()) {
                    Trace.trace(TRACE_MASKF, "Validator(s) exists");
                    if (this.formatter != null) {
                        Trace.trace(TRACE_MASKF, "Formatter exists so we'll call parse() prior to validator(s)");
                        this.runValidators(tc, comp, this.formatter.parse(newValue));
                    }
                    if (this.propertyType != null) {
                        Trace.trace(TRACE_MASKF, "No formatter exists so we'll implicitly convert and pass result to validator(s)");
                        try {
                            this.runValidators(tc, comp, ObjectFormatter.convert(newValue, this.propertyType));
                        }
                        catch (NoStandardFormatterException e) {
                            Trace.trace(TRACE_MASKF, "No standard conversion available, so we'll just call validator(s) with the raw data.");
                            this.runValidators(tc, comp, newValue);
                        }
                    }
                    Trace.trace(TRACE_MASKF, "No formatter exists and we couldn't determine property type, so we'll just pass the raw data to the real validator(s).");
                    this.runValidators(tc, comp, newValue);
                }
                if (this.formatter != null) {
                    Trace.trace(TRACE_MASKF, "No validators exists but a formatter exists, we'll just call parse() on it.");
                    this.formatter.parse(newValue);
                }
                Trace.trace(TRACE_MASKF, "WARNING No validators, no formatters... unexpected this is.");
            }
            catch (ValidationException e) {
                Trace.trace(TRACE_MASKF, "ValidationException caught.  \n\tMessage is: " + e.getMessage() + "\n\tCause is: " + e.getCause());
                if (this.node != null && this.node.isEnableEnabled() && !this.node.isEnabled()) {
                    this.clearErrors();
                    Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() returns true (" + this + ") (node !enabled)");
                    return true;
                }
                if (this.node != null && this.node.isReadonlyEnabled() && this.node.isReadonly()) {
                    this.clearErrors();
                    Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() returns true (" + this + ") (node was readonly)");
                    return true;
                }
                this.handleValidationException(e);
                Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() returns false (" + this + ") (ValidationException)");
                return false;
            }
        } else {
            Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() source component is a 'CANCEL' initiator, abandoning validation.");
            this.getPanelModel().getImplAccess().getWclEventProxyManager().setCancelEvent(true);
            if (comp instanceof WTimeChooser) {
                this.getPanelModel().getImplAccess().getWclEventProxyManager().fireSyntheticTimeChooserCancelEvent(tc);
            }
        }
        Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() returns true (" + this + ")");
        this.clearErrors();
        return true;
    }

    public void clearErrors() {
        Trace.trace(TRACE_MASKF, "WclGlueValidator.clearErrors()");
        if (this.lastErrorMessageId != null) {
            Iterator iterator = this.consumerList.iterator();
            while (iterator.hasNext()) {
                IMessageConsumer consumer = (IMessageConsumer)iterator.next();
                consumer.removeMessage(this.lastErrorMessageId);
            }
            this.lastErrorMessageId = null;
        }
    }

    public void handleValidationException(Exception e) {
        Trace.trace(TRACE_MASKF, "WclGlueValidator.handleValidationException(" + e + ")");
        this.clearErrors();
        if (e instanceof ValidationException && ((ValidationException)e).getMessageText() != null) {
            Trace.trace(TRACE_MASKF, "messageText != null");
            Iterator iterator = this.consumerList.iterator();
            while (iterator.hasNext()) {
                IMessageConsumer consumer = (IMessageConsumer)iterator.next();
                consumer.addMessage(new MessageInfo(Locale.getDefault(), ((ValidationException)e).getMessageText().getKey(), ((ValidationException)e).getMessageText().getResourceBundleName(), ((ValidationException)e).getMessageText().getMsgId(), 1, 0, ((ValidationException)e).getMessageText().getSubstitutionData(), null, false));
            }
            this.lastErrorMessageId = ((ValidationException)e).getMessageText().getMsgId();
        } else {
            Trace.trace(TRACE_MASKF, "messageText == null");
            Iterator iterator = this.consumerList.iterator();
            while (iterator.hasNext()) {
                IMessageConsumer consumer = (IMessageConsumer)iterator.next();
                consumer.addMessage(new MessageInfo(Locale.getDefault(), e.getMessage(), null, "", 1, 0, null, null, true));
                this.lastErrorMessageId = "";
            }
        }
    }

    private void runValidators(TriggerContext tc, WComponent comp, Object formattedObject) throws ValidationException {
        Trace.trace(TRACE_MASKF, "Running validators.");
        Iterator iterator = this.validators.iterator();
        while (iterator.hasNext()) {
            PmDataValidator validator = (PmDataValidator)iterator.next();
            validator.setTriggerContext(tc);
            validator.setComponent(comp);
            validator.validate(formattedObject);
        }
    }

    public void addConsumer(IMessageConsumer consumer) {
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("addConsumer(").append(consumer == null ? "null" : consumer.getClass().getName()).append(")"));
        if (consumer != null) {
            this.consumerList.add(consumer);
        }
    }

    public void removeConsumer(IMessageConsumer consumer) {
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("removeConsumer(").append(consumer == null ? "null" : consumer.getClass().getName()).append(")"));
        this.consumerList.remove(consumer);
    }
}

